%check for discontinuity in tracked points for all measurend frequencies,
%images, and markers
%%
norm_deviation=0.5; %sqrt(2*0.1^2);
error=0;
max=0;
max_m=0;
max_i=0;
max_folder='';
max_view='';
filenames={'_topview_top.dat';'_topview_bottom.dat';'_sideview_bottom.dat';'_sideview_top_left.dat';'_sideview_top_right.dat'};
%%%
subfolders = dir();
subfolders(~[subfolders.isdir]) = []; %remove non-directory entries
subfolders = subfolders(3:end);% remove '.' and '..'

for freq_number=1:length(subfolders)
    
    foldername = subfolders(freq_number).name;
    cd(foldername)
    
    
    for fnames=1:length(filenames)
        clear validx validy
        if isfile(strcat('validx',filenames{fnames}))
            validx=load(strcat('validx',filenames{fnames}));
        else
            continue
        end
        if isfile(strcat('validy',filenames{fnames}))
            validy=load(strcat('validy',filenames{fnames}));
        else
            continue
        end
        
        [markers,images]=size(validx);
        for m=1:markers
            for i=1:images-1
                deviation=sqrt((validx(m,i)-validx(m,i+1))^2+(validy(m,i)-validy(m,i+1))^2);
                if deviation>max
                 max=deviation;
                 max_m=m;
                 max_i=i;
                 max_folder=foldername;
                 max_view=filenames{fnames};
                end
                if deviation>norm_deviation
                disp(strcat('Discontinuity found for folder...',foldername,', ',filenames{fnames},', Image Nr.', num2str(i),', Marker Nr. ',num2str(m)))
                error=1;
                end
            end
        end
    end
    cd ../
end
disp(strcat('Maximum deviation:',num2str(max)))
if error==0
    disp('No discontinuities found')
else
    disp('Discontinuities found')
end

%show the two maximally deviation markers
cd(max_folder)
load('filenamelist')
imshow(filenamelist(max_i,:))                     % update image
validx=load(strcat('validx',max_view));
validy=load(strcat('validy',max_view));
hold on
plot(validx(max_m,max_i),validy(max_m,max_i),'g+')                                % plot start position of raster
plot(validx(max_m,max_i+1),validy(max_m,max_i+1),'r+')        % plot actual postition of raster
hold off
drawnow